;******************************************************************************
; Sprite Bounce Demo
;******************************************************************************
; A simple bouncing sprite demo.
;
; This demo uses libperspective to draw a masked sprite onto a static
; background. The sprite bounces off of screen edges.
;
; (C) Kresna Susila - 2018
;******************************************************************************

;------------------------------------------------------------------------------
; Variables
;------------------------------------------------------------------------------
; Greyscale demo variables
sb_bg_address           =       $7      ; 2 bytes
sb_spr_flags            =       $9      ; 1 byte
sb_spr_x_loc            =       $a      ; 1 byte
sb_spr_y_loc            =       $b      ; 1 byte
sb_spr_x_size           =       $c      ; 1 byte
sb_spr_y_size           =       $d      ; 1 byte
sb_spr_address          =       $e      ; 2 bytes
; -----------------
; Sprite Flags:
; -----------------
; MSB           LSB
;  7 6 5 4 3 2 1 0
; -----------------
;              | +- X Direction. 1 = negative, 0 = positive
;              +--- Y Direction. 1 = negative, 0 = positive
;------------------------------------------------------------------------------

Sprite_Bounce_Demo:
        ;----------------------------------------------------------------------
        ; Sprite Bounce Demo
        ;----------------------------------------------------------------------
        ; Initialise some variables
        mov     #%00000000, sb_spr_flags
        mov     #11, sb_spr_x_loc
        mov     #6, sb_spr_y_loc
        mov     #<heart_mask, acc
        st      trl
        st      sb_spr_address
        mov     #>heart_mask, acc
        st      trh
        st      sb_spr_address+1
        xor     acc
        ldc
        st      sb_spr_x_size
        mov     #1, acc
        ldc
        st      sb_spr_y_size

.demo_loop
        clr1    ocr, 5
        ; If sprite x = 0, reset x flag
        ld      sb_spr_x_loc
        bnz     .skip_x_reset
        clr1    sb_spr_flags, 0
.skip_x_reset
        ; If sprite x + sprite x size = 48, set x flag
        add     sb_spr_x_size
        sub     #48
        bnz     .skip_x_set
        set1    sb_spr_flags, 0
.skip_x_set

        ; If sprite y = 0, reset y flag
        ld      sb_spr_y_loc
        bnz     .skip_y_reset
        clr1    sb_spr_flags, 1
.skip_y_reset
        ; If sprite y + sprite y size = 32, set y flag
        add     sb_spr_y_size
        sub     #32
        bnz     .skip_y_set
        set1    sb_spr_flags, 1
.skip_y_set

        ; Update X pos
        bn      sb_spr_flags, 0, .inc_x
        dec     sb_spr_x_loc
        dec     sb_spr_x_loc
.inc_x
        inc     sb_spr_x_loc

        ; Update Y pos
        bn      sb_spr_flags, 1, .inc_y
        dec     sb_spr_y_loc
        dec     sb_spr_y_loc
.inc_y
        inc     sb_spr_y_loc

        ; Draw the sprite to the screen
        P_Draw_Background_Constant img_background
        P_Draw_Sprite_Mask sb_spr_address, sb_spr_x_loc, sb_spr_y_loc
        P_Blit_Screen

        set1    ocr, 5

        ; Generic input code to move between demos
        call    Get_Input
        mov     #Button_A, acc
        call    Check_Button_Pressed
        bz      .not_a
        ret
.not_a
        jmp     .demo_loop
