;******************************************************************************
; Custom Drawing Function Demo
;******************************************************************************
; A custom draw function demo.
;
; This demo uses the WRAM drawing and blitting features of libperspective to
; create a custom effects function. This function rotates lines in the
; framebuffer.
;
; (C) Kresna Susila - 2018
;******************************************************************************

Custom_Drawing_Demo:
        ;----------------------------------------------------------------------
        ; Custom Drawing Demo
        ;----------------------------------------------------------------------
        ; Draw the initial frame to the screen
        P_Draw_Background_Constant warning_banner
        P_Blit_Screen

.demo_loop
        ; Use our custom function to rotate lines on the screen
        CD_Rotate_Lines 1, 3
        CD_Rotate_Lines 11, 3
        P_Blit_Screen

        ; Generic input code to move between demos
        call    Get_Input
        mov     #Button_A, acc
        call    Check_Button_Pressed
        bz      .not_a
        ret
.not_a

        jmp     .demo_loop

%macro  CD_Rotate_Lines %line, %num
        ;----------------------------------------------------------------------
        ; A small macro to make our function easier to preload.
        ;----------------------------------------------------------------------
        ; Accepts:      Line number (8bit constant)
        ;               Number of lines to rotate (8bit constant)
        ; Destroys:     ACC, B, C, VRMAD1, VRMAD2, VSEL
        ;----------------------------------------------------------------------
        mov     #%line, acc
        mov     #%num, c
        call    _CD_Rotate_Lines
%end


_CD_Rotate_Lines:
        ;----------------------------------------------------------------------
        ; Rotate lines of the screen
        ;----------------------------------------------------------------------
        ; This is our custom function to do line rotation in WRAM. Since the
        ; frame buffer is a contiguous space in WRAM from $00 to $BF, we can
        ; easily iterate over the screen without having to worry about banks
        ; or 4 extra bytes every 2 lines, etc.
        ;
        ; We're not enabling RC clock in this, but we could if we wanted it to
        ; draw faster.
        ;
        ; Accepts:      ACC = Starting line number (8bit Constant)
        ;               C = Number of lines to rotate (8bit Constant)
        ; Destroys:     ACC, B, C, VRMAD1, VRMAD2, VSEL
        ;----------------------------------------------------------------------
        ; Prepare the frame buffer address
        mov     #P_WRAM_BANK, vrmad2
        mov     #%00000000, vsel

        ; Find the line we want to rotate
        ; vrmad1 + (acc * 6)
        ; We're dangerous, so we assume that acc is a valid line number to save
        ; time instead of masking.
        rol
        st      b
        rol
        add     b
        add     #P_WRAM_ADDR
        st      vrmad1

        ; We don't care to clear the carry flag since we're going to set the
        ; first bit later anyway

.rotate_line
        ; Preserve the address of the first byte of the line
        push    vrmad1

        ; Rotate through the line
        ld      vtrbf
        rorc
        st      vtrbf
        inc     vrmad1
        ld      vtrbf
        rorc
        st      vtrbf
        inc     vrmad1
        ld      vtrbf
        rorc
        st      vtrbf
        inc     vrmad1
        ld      vtrbf
        rorc
        st      vtrbf
        inc     vrmad1
        ld      vtrbf
        rorc
        st      vtrbf
        inc     vrmad1
        ld      vtrbf
        rorc
        st      vtrbf
        inc     vrmad1

        pop     vrmad1

        ; Mask the last bit onto the first bit
        xor     acc
        rorc
        st      b
        ld      vtrbf
        or      b
        st      vtrbf

        ; Move onto the next line
        ld      vrmad1
        add     #6
        st      vrmad1

        ; If we have no more lines, we're done
        dbnz    c, .rotate_line
        ret
